# [퇴근후딴짓] 2026 빅데이터 분석기사 실기 - 길벗 시나공 시리즈

[![Open in Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/)

> ✨✨✨ **초판 완판**에 힘입어 개정판을 출간하게 되었습니다. 진심으로 감사합니다! 🙇🏼‍♂️ ✨✨✨
### ✅ 개정판에서 보완된 점
- 🔥 기출 문제 보강: 최신 9회 실기시험 기출 문제를 추가하고, 쉬운 풀이 과정을 제공해 최근 출제 경향을 빠르게 파악할 수 있도록 함
- 🔥 판다스 이론 보강: 작업형 1에서 문제를 쉽게 풀기 위한 함수와 유용한 활용 팁을 추가하여, 이해와 실전 응용력을 높임
- 🔥 작업형1 연습 문제 추가: 최신 출제 경향을 반영한 작업형1 문제를 새롭게 추가해, 실기 시험 대비를 더욱 탄탄하게 함
- 🔥 그 외 작업형3 연습문제(로지스틱 회귀) 등 수정 보완

### 🌱 도서 링크
- [교보문고](https://product.kyobobook.co.kr/detail/S000216355151), [yes24](https://www.yes24.com/product/goods/145638676)

### 🌱 강의 링크
- 유튜브(무료): [링크](https://youtube.com/playlist?list=PLSlDi2AkDv82Qv7B3WiWypQSFmOCb-G_-&si=TssmZSX6UTBdKw5C)
- 인프런 강의: [링크](https://inf.run/XnzT) (입문자에게는 강의 추천)

### 🌱 정오표:
- https://bit.ly/41SQB3x

### 🌱 목차
- Intro. 시험 응시 전략, 시험 환경 소개, 코드 및 데이터 불러오기, 자주하는 질문 등
- PART1. 작업형1 (파이썬, 판다스, 연습문제)
- PART2. 작업형2 (이진분류, 다중분류, 회귀, 평가지표, 연습문제)
- PART3. 작업형3 (가설검정, 분산 분석, 카이제곱, 회귀, 로지스틱 회귀, 연습문제)
- PART4. 기출유형 (예시문제, 2회 ~ 9회까지)



### 🌱 예제코드 바로 실행하는 방법
- 노트북 선택(part/chapter) -> 구글 코랩에서 실행하기 -> Drive로 복사 -> 실행
![guide_colab](https://github.com/user-attachments/assets/840d2a4f-a725-4320-9c84-c76d37f910d7)

### 🌱 예제코드 전체 다운로드 방법
- "Code" 버튼 클릭 -> 풀다운 메뉴에서 "Download Zip"을 선택
- 입문자는 "예제코드 바로 실행하는 방법"을 추천합니다. 
<img width="819" alt="Screenshot 2024-08-21 at 11 58 59 AM" src="https://github.com/user-attachments/assets/4ade48e7-9071-4849-9ea1-5828de49e554">


### 🌱 생성형AI와 함께 공부하길 추천합니다
- 문제 발생시 제공된 최종 노트북 코드와 현재 코드를 비교하여 문제를 파악해보세요. 코드를 복사하여 붙여넣기 한 후 정상적으로 실행되는지 확인
- 문제가 지속될 경우, ChatGPT(https://chat.openai.com/), Claude(https://claude.ai) 를 활용

### 🌱 안내사항
- 응원합니다 :) 

### 🌱 커뮤니티
- 10회 스터디(오징어게임) 초대장 : [링크](https://quakka.notion.site/10-1d77e3769e2e801eacced76144d3520c?pvs=4)
- 디스코드 입장 링크: https://discord.gg/V8acvTnHhH (초대장 내용을 먼저 읽어 주세요)
- 학습과 관련해 1:1 질의응답은 진행하지 않습니다. 미션을 수행하고, 멤버간 질의응답을 하는 공간입니다. 

### 레포지토리 구조
```text
.
├── README.md
├── part1
│   ├── ch1
│   │   └── ch1_python.ipynb (코드)
│   ├── ch2
│   │   └── ch2_pandas.ipynb (코드)
│   └── ch3
│       ├── ch3_ex_type1.ipynb (코드)
│       ├── delivery_time.csv
│       ├── monthly_sales.csv
│       ├── region_sales.csv
│       ├── sales.csv
│       ├── school_data.csv
│       ├── school_data_science.csv
│       ├── school_data_social.csv
│       ├── store_sales.csv
│       ├── type1_data1.csv
│       └── type1_data2.csv
├── part2
│   ├── ch2
│   │   ├── ch2_classification.ipynb (코드)
│   │   ├── test.csv
│   │   └── train.csv
│   ├── ch3
│   │   └── ch3_metrics.ipynb (코드)
│   ├── ch4
│   │   ├── ch4_regression.ipynb (코드)
│   │   ├── test.csv
│   │   └── train.csv
│   ├── ch5
│   │   ├── ch5_multi_class_classification.ipynb (코드)
│   │   ├── test.csv
│   │   └── train.csv
│   ├── ch6
│   │   ├── ch6_ex_classification.ipynb (코드)
│   │   ├── creditcard_test.csv
│   │   ├── creditcard_train.csv
│   │   ├── diabetes_test.csv
│   │   ├── diabetes_train.csv
│   │   ├── hr_test.csv
│   │   └── hr_train.csv
│   ├── ch7
│   │   ├── ch7_ex_multi_class_classification.ipynb (코드)
│   │   ├── drug_test.csv
│   │   ├── drug_train.csv
│   │   ├── glass_test.csv
│   │   ├── glass_train.csv
│   │   ├── score_test.csv
│   │   └── score_train.csv
│   └── ch8
│       ├── car_test.csv
│       ├── car_train.csv
│       ├── ch8_ex_regression.ipynb (코드)
│       ├── flight_test.csv
│       ├── flight_train.csv
│       ├── laptop_test.csv
│       └── laptop_train.csv
├── part3
│   ├── ch1
│   │   └── ch1_hypothesis_testing.ipynb (코드)
│   ├── ch2
│   │   ├── ch2_anova.ipynb (코드)
│   │   ├── fertilizer.csv
│   │   └── tree.csv
│   ├── ch3
│   │   └── ch3_chi_square.ipynb (코드)
│   ├── ch4
│   │   ├── ch4_linear_regression.ipynb (코드)
│   │   └── study.csv
│   ├── ch5
│   │   ├── ch5_logistic_regression.ipynb (코드)
│   │   └── health_survey.csv
│   └── ch6
│       ├── ch6_ex_type3.ipynb (코드)
│       ├── math.csv
│       └── tomato2.csv
└── part4
    ├── ch2
    │   ├── X_test.csv
    │   ├── X_train.csv
    │   ├── members.csv
    │   ├── p2_type1.ipynb (작업형1 코드)
    │   ├── p2_type2.ipynb (작업형2 코드)
    │   └── y_train.csv
    ├── ch3
    │   ├── members.csv
    │   ├── p3_type1.ipynb (작업형1 코드)
    │   ├── p3_type2.ipynb (작업형2 코드)
    │   ├── test.csv
    │   ├── train.csv
    │   └── year.csv
    ├── ch4
    │   ├── data4-1.csv
    │   ├── data4-2.csv
    │   ├── data4-3.csv
    │   ├── p4_type1.ipynb (작업형1 코드)
    │   ├── p4_type2.ipynb (작업형2 코드)
    │   ├── test.csv
    │   └── train.csv
    ├── ch5
    │   ├── data5-1.csv
    │   ├── data5-2.csv
    │   ├── data5-3.csv
    │   ├── p5_type1.ipynb (작업형1 코드)
    │   ├── p5_type2.ipynb (작업형2 코드)
    │   ├── test.csv
    │   └── train.csv
    ├── ch6
    │   ├── data6-1-1.csv
    │   ├── data6-1-2.csv
    │   ├── data6-1-3.csv
    │   ├── data6-3-2.csv
    │   ├── energy_test.csv
    │   ├── energy_train.csv
    │   ├── p6_type1.ipynb (작업형1 코드)
    │   ├── p6_type2.ipynb (작업형2 코드)
    │   └── p6_type3.ipynb (작업형3 코드)
    ├── ch7
    │   ├── air_quality.csv
    │   ├── clam.csv
    │   ├── mart_test.csv
    │   ├── mart_train.csv
    │   ├── p7_type1.ipynb (작업형1 코드)
    │   ├── p7_type2.ipynb (작업형2 코드)
    │   ├── p7_type3.ipynb (작업형3 코드)
    │   ├── stock_market.csv
    │   ├── student_assessment.csv
    │   └── system_cpu.csv
    ├── ch8
    │   ├── chem.csv
    │   ├── churn.csv
    │   ├── churn_test.csv
    │   ├── churn_train.csv
    │   ├── drinks.csv
    │   ├── p8_type1.ipynb (작업형1 코드)
    │   ├── p8_type2.ipynb (작업형2 코드)
    │   ├── p8_type3.ipynb (작업형3 코드)
    │   ├── piq.csv
    │   └── tourist.csv
    └── ch9
        ├── crime.csv
        ├── design.csv
        ├── farm_test.csv
        ├── farm_train.csv
        ├── hr.csv
        ├── loan.csv
        ├── p9_type1.ipynb (작업형1 코드)
        ├── p9_type2.ipynb (작업형2 코드)
        ├── p9_type3.ipynb (작업형3 코드)
        └── retention.csv
```

이 레포지토리에 실린 모든 내용의 저작권은 저자에게 있으며, 저자의 허락 없이 이 코드의 일부 또는 전부를 복제, 배포할 수 없습니다.

